"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDataServiceProxy = void 0;
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _proxies = require("../utils/proxies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create proxy for the data service, in which session service enablement calls
 * are no-ops.
 */
const createDataServiceProxy = ({
  data,
  http,
  uiSettings
}) => {
  /**
   * search session
   */
  const noOpEnableStorage = () => {};
  const sessionServiceProxy = (0, _proxies.createPropertyGetProxy)(data.search.session, {
    enableStorage: () => noOpEnableStorage
  });
  const searchServiceProxy = (0, _proxies.createPropertyGetProxy)(data.search, {
    session: () => sessionServiceProxy
  });

  /**
   * query
   */
  const customStorage = new _public2.Storage(localStorage);
  const customQueryService = new _public.QueryService();
  customQueryService.setup({
    nowProvider: new _public.NowProvider(),
    storage: customStorage,
    uiSettings
  });
  const customQuery = customQueryService.start({
    http,
    storage: customStorage,
    uiSettings
  });

  /**
   * combined
   */
  return (0, _proxies.createPropertyGetProxy)(data, {
    query: () => customQuery,
    search: () => searchServiceProxy
  });
};
exports.createDataServiceProxy = createDataServiceProxy;