"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogSourcesServiceFactory = createLogSourcesServiceFactory;
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _utils = require("../../../common/services/log_sources_service/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createLogSourcesServiceFactory(params) {
  return {
    async getLogSourcesService(savedObjectsClient) {
      const {
        uiSettings
      } = params.deps;
      const uiSettingsClient = uiSettings.asScopedToClient(savedObjectsClient);
      const logSourcesService = {
        async getLogSources() {
          const logSources = await uiSettingsClient.get(_managementSettingsIds.OBSERVABILITY_LOGS_DATA_ACCESS_LOG_SOURCES_ID);
          return logSources.map(logSource => ({
            indexPattern: logSource
          }));
        },
        async getFlattenedLogSources() {
          const logSources = await this.getLogSources();
          return (0, _utils.flattenLogSources)(logSources);
        },
        async setLogSources(sources) {
          return await uiSettingsClient.set(_managementSettingsIds.OBSERVABILITY_LOGS_DATA_ACCESS_LOG_SOURCES_ID, sources.map(source => source.indexPattern));
        }
      };
      return logSourcesService;
    },
    async getScopedLogSourcesService(request) {
      const {
        savedObjects
      } = params.deps;
      const soClient = savedObjects.getScopedClient(request);
      return this.getLogSourcesService(soClient);
    }
  };
}