"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogSourcesSettingSynchronisationInfo = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogSourcesSettingSynchronisationInfo = ({
  isLoading,
  logSourcesValue,
  getUrlForApp,
  title
}) => {
  const advancedSettingsHref = (0, _react.useMemo)(() => getUrlForApp('management', {
    path: `/kibana/settings?query=${encodeURIComponent('Log sources')}`
  }), [getUrlForApp]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h4", null, title !== null && title !== void 0 ? title : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logsDataAccess.logSourcesSettingInfo.logSourcesSettingTitle",
      defaultMessage: "Log sources"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logsDataAccess.logSourcesSettingInfo.logSourcesSettingDescription",
      defaultMessage: "This value is synchronised with the Kibana log sources advanced setting. It can be changed via the {advancedSettingsLink}.",
      values: {
        advancedSettingsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "xpack.infra.logSourcesSettingInfo.logSourcesSettingLink",
          href: advancedSettingsHref
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.logsDataAccess.logSourcesSettingInfo.logSourcesSettingLinkText",
          defaultMessage: "advanced settings page"
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logsDataAccess.logSourcesSettingInfo.logSourcesSettingLabel",
      defaultMessage: "Log sources advanced setting"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "logSourcesSettingInput",
    fullWidth: true,
    disabled: true,
    isLoading: isLoading,
    value: logSourcesValue,
    isInvalid: false
  }))));
};
exports.LogSourcesSettingSynchronisationInfo = LogSourcesSettingSynchronisationInfo;