"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BuilderLogicButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiButton = (0, _styledComponents.default)(_eui.EuiButton)`
  min-width: 95px;
`;
const BuilderLogicButtons = ({
  isAndDisabled = false,
  isNested,
  isNestedDisabled = true,
  isOrDisabled = false,
  isOrHidden = false,
  showNestedButton = false,
  onAddClickWhenNested,
  onAndClicked,
  onNestedClicked,
  onOrClicked
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(MyEuiButton, {
  size: "s",
  iconType: "plusInCircle",
  onClick: isNested ? onAddClickWhenNested : onAndClicked,
  "data-test-subj": "exceptionsAndButton",
  isDisabled: isAndDisabled
}, i18n.AND)), !isOrHidden && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(MyEuiButton, {
  fill: true,
  size: "s",
  iconType: "plusInCircle",
  onClick: onOrClicked,
  isDisabled: isOrDisabled,
  "data-test-subj": "exceptionsOrButton"
}, i18n.OR)), showNestedButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  size: "s",
  iconType: "nested",
  onClick: isNested ? onAndClicked : onNestedClicked,
  isDisabled: isNestedDisabled,
  "data-test-subj": "exceptionsNestedButton"
}, isNested ? i18n.ADD_NON_NESTED_DESCRIPTION : i18n.ADD_NESTED_DESCRIPTION)));
exports.BuilderLogicButtons = BuilderLogicButtons;