"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../common");
var _content_management = require("./content_management");
var _saved_objects = require("./saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class LinksServerPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initializerContext = initializerContext;
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    plugins.contentManagement.register({
      id: _common.CONTENT_ID,
      storage: new _content_management.LinksStorage({
        throwOnResultValidationError: this.initializerContext.env.mode.dev,
        logger: this.logger.get('storage')
      }),
      version: {
        latest: _common.LATEST_VERSION
      }
    });
    core.savedObjects.registerType(_saved_objects.linksSavedObjectType);
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.LinksServerPlugin = LinksServerPlugin;