"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runSaveToLibrary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-objects-plugin/public");
var _common = require("../../common");
var _duplicate_title_check = require("./duplicate_title_check");
var _links_content_management_client = require("./links_content_management_client");
var _serialize_attributes = require("../lib/serialize_attributes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const modalTitle = _i18n.i18n.translate('links.contentManagement.saveModalTitle', {
  defaultMessage: `Save {contentId} panel to library`,
  values: {
    contentId: _common.CONTENT_ID
  }
});
const runSaveToLibrary = async newState => {
  return new Promise((resolve, reject) => {
    var _newState$title2;
    const onSave = async ({
      newTitle,
      newDescription,
      onTitleDuplicate,
      isTitleDuplicateConfirmed
    }) => {
      var _newState$title;
      const stateFromSaveModal = {
        title: newTitle,
        description: newDescription
      };
      if (!(await (0, _duplicate_title_check.checkForDuplicateTitle)({
        title: newTitle,
        lastSavedTitle: (_newState$title = newState.title) !== null && _newState$title !== void 0 ? _newState$title : '',
        copyOnSave: false,
        onTitleDuplicate,
        isTitleDuplicateConfirmed
      }))) {
        return {};
      }
      const {
        attributes,
        references
      } = (0, _serialize_attributes.serializeLinksAttributes)(newState);
      const newAttributes = {
        ...attributes,
        ...stateFromSaveModal
      };
      try {
        const {
          item: {
            id
          }
        } = await _links_content_management_client.linksClient.create({
          data: {
            ...newAttributes,
            title: newTitle
          },
          options: {
            references
          }
        });
        resolve({
          ...newState,
          defaultTitle: newTitle,
          defaultDescription: newDescription,
          savedObjectId: id
        });
        return {
          id
        };
      } catch (error) {
        reject(error);
        return {
          error
        };
      }
    };
    const saveModal = /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModalWithSaveResult, {
      onSave: onSave,
      onClose: () => resolve(undefined),
      title: (_newState$title2 = newState.title) !== null && _newState$title2 !== void 0 ? _newState$title2 : '',
      customModalTitle: modalTitle,
      description: newState.description,
      showDescription: true,
      showCopyOnSave: false,
      objectType: _common.CONTENT_ID
    });
    (0, _public.showSaveModal)(saveModal);
  });
};
exports.runSaveToLibrary = runSaveToLibrary;