"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitlesAndTextPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _visualizationUtils = require("@kbn/visualization-utils");
var _shared_components = require("../../../shared_components");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TitlesAndTextPopover = ({
  state,
  setState,
  groupPosition
}) => {
  var _state$titlesTextAlig, _state$iconAlign, _state$valuesTextAlig, _state$valueFontMode;
  return /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.metric.toolbarTitlesText.label', {
      defaultMessage: 'Titles and text'
    }),
    type: "titlesAndText",
    groupPosition: groupPosition,
    buttonDataTestSubj: "lnsTextOptionsButton"
  }, !state.breakdownByAccessor && /*#__PURE__*/_react.default.createElement(SubtitleOption, {
    value: state.subtitle,
    onChange: subtitle => {
      setState({
        ...state,
        subtitle
      });
    }
  }), /*#__PURE__*/_react.default.createElement(TitlesAlignmentOption, {
    value: (_state$titlesTextAlig = state.titlesTextAlign) !== null && _state$titlesTextAlig !== void 0 ? _state$titlesTextAlig : _constants.metricStateDefaults.titlesTextAlign,
    onChange: titlesTextAlign => {
      setState({
        ...state,
        titlesTextAlign
      });
    }
  }), state.icon && state.icon !== 'empty' && /*#__PURE__*/_react.default.createElement(IconAlignmentOption, {
    value: (_state$iconAlign = state.iconAlign) !== null && _state$iconAlign !== void 0 ? _state$iconAlign : _constants.metricStateDefaults.iconAlign,
    onChange: iconAlign => {
      setState({
        ...state,
        iconAlign
      });
    }
  }), /*#__PURE__*/_react.default.createElement(ValuesAlignmentOption, {
    value: (_state$valuesTextAlig = state.valuesTextAlign) !== null && _state$valuesTextAlig !== void 0 ? _state$valuesTextAlig : _constants.metricStateDefaults.valuesTextAlign,
    onChange: valuesTextAlign => {
      setState({
        ...state,
        valuesTextAlign
      });
    }
  }), /*#__PURE__*/_react.default.createElement(ValueFontSizeOption, {
    value: (_state$valueFontMode = state.valueFontMode) !== null && _state$valueFontMode !== void 0 ? _state$valueFontMode : _constants.metricStateDefaults.valueFontMode,
    onChange: value => {
      setState({
        ...state,
        valueFontMode: value
      });
    }
  }));
};
exports.TitlesAndTextPopover = TitlesAndTextPopover;
function SubtitleOption({
  value = '',
  onChange
}) {
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange,
    value
  }, {
    allowFalsyValue: true
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.metric.subtitleLabel', {
      defaultMessage: 'Subtitle'
    }),
    fullWidth: true,
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    "data-test-subj": "lens-metric-subtitle-field",
    value: inputValue,
    onChange: ({
      target: {
        value: newValue
      }
    }) => handleInputChange(newValue)
  }));
}
const valueFontModes = [{
  id: 'default',
  label: _i18n.i18n.translate('xpack.lens.metric.toolbarTitlesText.default', {
    defaultMessage: 'Default'
  })
}, {
  id: 'fit',
  label: _i18n.i18n.translate('xpack.lens.metric.toolbarTitlesText.fit', {
    defaultMessage: 'Fit'
  })
}];
function ValueFontSizeOption({
  value,
  onChange
}) {
  const label = _i18n.i18n.translate('xpack.lens.metric.toolbarTitlesText.valueFontSize', {
    defaultMessage: 'Value font size'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: /*#__PURE__*/_react.default.createElement("span", null, label, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.lens.metric.toolbarTitlesText.valueFontSizeTip', {
        defaultMessage: 'Font size of the Primary metric value'
      }),
      iconProps: {
        className: 'eui-alignTop'
      },
      color: "subdued",
      position: "top",
      size: "s",
      type: "question"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: label,
    "data-test-subj": "lens-value-font-mode-btn",
    buttonSize: "compressed",
    idSelected: value,
    options: valueFontModes,
    onChange: mode => {
      onChange(mode);
    }
  }));
}
const alignmentOptions = [{
  id: 'left',
  label: _i18n.i18n.translate('xpack.lens.shared.left', {
    defaultMessage: 'Left'
  })
}, {
  id: 'center',
  label: _i18n.i18n.translate('xpack.lens.shared.center', {
    defaultMessage: 'Center'
  })
}, {
  id: 'right',
  label: _i18n.i18n.translate('xpack.lens.shared.right', {
    defaultMessage: 'Right'
  })
}];
function TitlesAlignmentOption({
  value,
  onChange
}) {
  const label = _i18n.i18n.translate('xpack.lens.metric.toolbarTitlesText.titlesAlignment', {
    defaultMessage: 'Titles alignment'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: /*#__PURE__*/_react.default.createElement("span", null, label, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.lens.metric.toolbarTitlesText.titlesAlignmentTip', {
        defaultMessage: 'Alignment of the Title and Subtitle'
      }),
      iconProps: {
        className: 'eui-alignTop'
      },
      color: "subdued",
      position: "top",
      size: "s",
      type: "question"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: label,
    "data-test-subj": "lens-titles-alignment-btn",
    buttonSize: "compressed",
    options: alignmentOptions,
    idSelected: value,
    onChange: alignment => {
      onChange(alignment);
    }
  }));
}
function ValuesAlignmentOption({
  value,
  onChange
}) {
  const label = _i18n.i18n.translate('xpack.lens.metric.toolbarTitlesText.valuesAlignment', {
    defaultMessage: 'Values alignment'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: /*#__PURE__*/_react.default.createElement("span", null, label, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: _i18n.i18n.translate('xpack.lens.metric.toolbarTitlesText.valuesAlignmentTip', {
        defaultMessage: 'Alignment of the Primary and Secondary Metrics'
      }),
      iconProps: {
        className: 'eui-alignTop'
      },
      position: "top",
      size: "s",
      type: "question"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: label,
    "data-test-subj": "lens-values-alignment-btn",
    buttonSize: "compressed",
    options: alignmentOptions,
    idSelected: value,
    onChange: alignment => {
      onChange(alignment);
    }
  }));
}
const iconAlignmentOptions = [{
  id: 'left',
  label: _i18n.i18n.translate('xpack.lens.shared.left', {
    defaultMessage: 'Left'
  })
}, {
  id: 'right',
  label: _i18n.i18n.translate('xpack.lens.shared.right', {
    defaultMessage: 'Right'
  })
}];
function IconAlignmentOption({
  value,
  onChange
}) {
  const label = _i18n.i18n.translate('xpack.lens.metric.toolbarTitlesText.iconAlignment', {
    defaultMessage: 'Icon alignment'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: label,
    "data-test-subj": "lens-icon-alignment-btn",
    buttonSize: "compressed",
    options: iconAlignmentOptions,
    idSelected: value,
    onChange: alignment => {
      onChange(alignment);
    }
  }));
}