"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildColumnsMetaLookup = void 0;
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildColumnsMetaLookupInner(table) {
  return table.columns.reduce((memo, {
    id,
    name,
    meta
  }, i) => {
    memo[id] = {
      name,
      index: i,
      meta
    };
    return memo;
  }, {});
}
const buildColumnsMetaLookup = exports.buildColumnsMetaLookup = (0, _memoizeOne.default)(buildColumnsMetaLookupInner);