"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderWithProviders = exports.mountWithProviders = void 0;
var _eui = require("@elastic/eui");
var _mocks = require("@kbn/core/public/mocks");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("@testing-library/react");
var _enzyme = require("enzyme");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderWithProviders = (ui, renderOptions) => {
  const {
    wrapper,
    ...options
  } = renderOptions || {};
  const CustomWrapper = wrapper;
  const Wrapper = ({
    children
  }) => {
    return /*#__PURE__*/_react2.default.createElement(_public.KibanaContextProvider, {
      services: _mocks.coreMock.createStart()
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiThemeProvider, null, wrapper ? /*#__PURE__*/_react2.default.createElement(CustomWrapper, null, children) : children)));
  };
  const rtlRender = (0, _react.render)(ui, {
    wrapper: Wrapper,
    ...options
  });
  return rtlRender;
};

// legacy enzyme usage: remove when all tests are migrated to @testing-library/react
exports.renderWithProviders = renderWithProviders;
const mountWithProviders = (component, options) => {
  const {
    wrappingComponent,
    wrappingComponentProps
  } = options || {};
  const WrappingComponent = wrappingComponent;
  const wrapper = ({
    children
  }) => /*#__PURE__*/_react2.default.createElement(_public.KibanaContextProvider, {
    services: _mocks.coreMock.createStart()
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiThemeProvider, null, WrappingComponent ? /*#__PURE__*/_react2.default.createElement(WrappingComponent, wrappingComponentProps, children) : children)));
  const instance = (0, _enzyme.mount)(component, {
    ...options,
    wrappingComponent: wrapper
  });
  return instance;
};
exports.mountWithProviders = mountWithProviders;