"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IgnoreGlobalFilterRowControl = IgnoreGlobalFilterRowControl;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IgnoreGlobalFilterRowControl({
  checked,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.layerSettings.ignoreGlobalFilters', {
      defaultMessage: 'Use global filters'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.lens.layerSettings.ignoreGlobalFilters', {
      defaultMessage: 'Use global filters'
    }),
    showLabel: false,
    checked: checked,
    "data-test-subj": "lns-layerSettings-ignoreGlobalFilters",
    onChange: () => onChange(!checked),
    compressed: true
  }));
}