"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuccessfulRequestTimings = getSuccessfulRequestTimings;
var _common = require("@kbn/inspector-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSuccessfulRequestTimings(inspectorAdapters) {
  var _inspectorAdapters$re;
  const requests = ((_inspectorAdapters$re = inspectorAdapters.requests) === null || _inspectorAdapters$re === void 0 ? void 0 : _inspectorAdapters$re.getRequests()) || [];
  let esTookTotal = 0;
  let requestTimeTotal = 0;
  for (let i = 0; i < requests.length; i++) {
    var _rawResponse$took, _request$response, _request$response$jso, _request$response$jso2;
    const request = requests[i];
    if (request.status !== _common.RequestStatus.OK) {
      return null;
    }
    esTookTotal += (_rawResponse$took = (_request$response = request.response) === null || _request$response === void 0 ? void 0 : (_request$response$jso = _request$response.json) === null || _request$response$jso === void 0 ? void 0 : (_request$response$jso2 = _request$response$jso.rawResponse) === null || _request$response$jso2 === void 0 ? void 0 : _request$response$jso2.took) !== null && _rawResponse$took !== void 0 ? _rawResponse$took : 0;
    requestTimeTotal += request.time || 0;
  }
  return {
    requestTimeTotal,
    esTookTotal
  };
}