"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trackUiCounterEvents = exports.trackSaveUiCounterEvents = exports.setUsageCollectionStart = exports.getUsageCollectionStart = exports.getExecutionContextEvents = void 0;
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _analytics = require("@kbn/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const [getUsageCollectionStart, setUsageCollectionStart] = (0, _public.createGetterSetter)('UsageCollection', false);
exports.setUsageCollectionStart = setUsageCollectionStart;
exports.getUsageCollectionStart = getUsageCollectionStart;
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};
const RENDER_EVENT_PREFIX = `render_lens_`;
const SAVE_EVENT_PREFIX = `save_lens_`;

/** @internal **/
const trackSaveUiCounterEvents = (events, context) => trackUiCounterEvents(events, context, SAVE_EVENT_PREFIX);

/** @internal **/
exports.trackSaveUiCounterEvents = trackSaveUiCounterEvents;
const trackUiCounterEvents = (events, context, eventPrefix = RENDER_EVENT_PREFIX) => {
  var _extractContainerType;
  const usageCollection = getUsageCollectionStart();
  const containerType = (_extractContainerType = extractContainerType(context)) !== null && _extractContainerType !== void 0 ? _extractContainerType : 'application';
  Object.entries((0, _lodash.groupBy)(Array.isArray(events) ? events : [events])).forEach(([key, counter]) => {
    usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, `${eventPrefix}${key}`, counter.length);
  });
};

/** @internal **/
exports.trackUiCounterEvents = trackUiCounterEvents;
const getExecutionContextEvents = context => {
  const events = [];
  if (context !== null && context !== void 0 && context.type) {
    events.push(`vis_${context.type}`);
  }
  return events;
};
exports.getExecutionContextEvents = getExecutionContextEvents;