"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.datatableFn = exports.DatatableInspectorTables = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _summary = require("./summary");
var _transpose_helpers = require("./transpose_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Available datatables logged to inspector
 */
const DatatableInspectorTables = exports.DatatableInspectorTables = {
  Default: 'default',
  Transpose: 'transpose'
};
const datatableFn = getFormatFactory => async (table, args, context) => {
  var _context$inspectorAda, _context$isSyncColors, _context$isSyncColors2, _ref;
  const columnSortMap = args.columns.reduce((acc, c, i) => acc.set(c.columnId, i), new Map());
  const getColumnSort = id => {
    var _columnSortMap$get;
    return (_columnSortMap$get = columnSortMap.get(id)) !== null && _columnSortMap$get !== void 0 ? _columnSortMap$get : -1;
  };
  const sortedTable = {
    ...table,
    columns: table.columns.slice().sort((a, b) => getColumnSort(a.id) - getColumnSort(b.id))
  };
  if (context !== null && context !== void 0 && (_context$inspectorAda = context.inspectorAdapters) !== null && _context$inspectorAda !== void 0 && _context$inspectorAda.tables) {
    context.inspectorAdapters.tables.reset();
    context.inspectorAdapters.tables.allowCsvExport = true;
    const logTable = (0, _utils.prepareLogTable)(sortedTable, [[args.columns.map(column => column.columnId), _i18n.i18n.translate('xpack.lens.datatable.column.help', {
      defaultMessage: 'Datatable column'
    })]], true);
    context.inspectorAdapters.tables.logDatatable(DatatableInspectorTables.Default, logTable);
  }
  let untransposedData;
  const formatters = {};
  const formatFactory = await getFormatFactory(context);
  sortedTable.columns.forEach(column => {
    var _column$meta;
    formatters[column.id] = formatFactory((_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.params);
  });
  const hasTransposedColumns = args.columns.some(c => c.isTransposed);
  if (hasTransposedColumns) {
    var _context$inspectorAda2;
    // store original shape of data separately
    untransposedData = (0, _lodash.cloneDeep)(sortedTable);
    // transposes table and args in-place
    (0, _transpose_helpers.transposeTable)(args, sortedTable, formatters);
    if (context !== null && context !== void 0 && (_context$inspectorAda2 = context.inspectorAdapters) !== null && _context$inspectorAda2 !== void 0 && _context$inspectorAda2.tables) {
      const logTransposedTable = (0, _utils.prepareLogTable)(sortedTable, [[args.columns.map(column => column.columnId), _i18n.i18n.translate('xpack.lens.datatable.column.help', {
        defaultMessage: 'Datatable column'
      })]], true);
      context.inspectorAdapters.tables.logDatatable(DatatableInspectorTables.Transpose, logTransposedTable);
      context.inspectorAdapters.tables.initialSelectedTable = DatatableInspectorTables.Transpose;
    }
  }
  const columnsWithSummary = args.columns.filter(c => c.summaryRow);
  for (const column of columnsWithSummary) {
    column.summaryRowValue = (0, _summary.computeSummaryRowForColumn)(column, sortedTable, formatters, formatFactory({
      id: 'number'
    }));
  }
  return {
    type: 'render',
    as: 'lens_datatable_renderer',
    value: {
      data: sortedTable,
      untransposedData,
      syncColors: (_context$isSyncColors = (_context$isSyncColors2 = context.isSyncColorsEnabled) === null || _context$isSyncColors2 === void 0 ? void 0 : _context$isSyncColors2.call(context)) !== null && _context$isSyncColors !== void 0 ? _context$isSyncColors : false,
      args: {
        ...args,
        title: (_ref = context.variables.embeddableTitle) !== null && _ref !== void 0 ? _ref : args.title
      }
    }
  };
};
exports.datatableFn = datatableFn;