"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = depth => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      size,
      colors,
      border
    } = euiTheme;
    const loadMoreButton = {
      position: 'relative',
      textAlign: 'center',
      width: `calc(100% + ${depth * 24}px)`,
      marginLeft: `-${depth * 24}px`,
      '&::after': {
        content: `''`,
        position: 'absolute',
        top: '50%',
        width: '100%',
        border: `${border.width.thin} dashed ${colors.mediumShade}`,
        left: 0
      },
      '&:hover, &:focus': {
        backgroundColor: 'transparent'
      },
      '.euiTreeView__nodeLabel': {
        width: '100%'
      }
    };
    const loadMoreBadge = {
      position: 'relative',
      cursor: 'pointer',
      zIndex: 2,
      '.euiBadge__content': {
        gap: size.xs
      }
    };
    const nonInteractiveItem = {
      pointerEvents: 'none',
      '&:hover, &:focus': {
        backgroundColor: 'transparent'
      }
    };
    const euiTreeViewWrapper = {
      ul: {
        marginLeft: '0 !important',
        fontSize: 'inherit'
      },
      // Override default EUI max-height - `DynamicTreeView` has its own scrolling container
      '.euiTreeView__node': {
        maxBlockSize: 'none'
      }
    };
    return {
      loadMoreButton,
      loadMoreBadge,
      nonInteractiveItem,
      euiTreeViewWrapper
    };
  }, [euiTheme, depth]);
  return cached;
};
exports.useStyles = useStyles;