"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Breadcrumb = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _types = require("../../../types");
var _styles = require("./styles");
var _helpers = require("../helpers");
var _helper = require("./helper");
var _translations = require("../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Breadcrumb = ({
  treeNavSelection,
  onSelect
}) => {
  const styles = (0, _styles.useStyles)();
  const {
    euiVars
  } = (0, _hooks.useEuiTheme)();
  const onBreadCrumbClick = (0, _react.useCallback)(collectionType => {
    return async () => {
      const selectionCopy = {
        ...treeNavSelection
      };
      switch (collectionType) {
        case _types.KubernetesTreeViewLevels.clusterId:
          {
            onSelect({
              clusterId: treeNavSelection.clusterId,
              clusterName: treeNavSelection.clusterName
            });
            break;
          }
        case _types.KubernetesTreeViewLevels.namespace:
        case _types.KubernetesTreeViewLevels.node:
          {
            delete selectionCopy.pod;
            delete selectionCopy.containerImage;
            onSelect(selectionCopy);
            break;
          }
        case _types.KubernetesTreeViewLevels.pod:
          {
            delete selectionCopy.containerImage;
            onSelect(selectionCopy);
            break;
          }
      }
    };
  }, [onSelect, treeNavSelection]);
  const renderBreadcrumbLink = (0, _react.useCallback)((collectionType, treeViewIconProps, isBolded, hasRightArrow = true) => {
    const clusterLevel = _translations.BREADCRUMBS_CLUSTER_TREE_VIEW_LEVELS[collectionType];
    const resourceName = collectionType === _types.KubernetesTreeViewLevels.clusterId ? treeNavSelection.clusterName || treeNavSelection.clusterId : treeNavSelection[collectionType];
    const tooltip = `${clusterLevel}: ${resourceName}`;
    const showBreadcrumbText = (0, _helper.showBreadcrumbDisplayText)(treeNavSelection, collectionType);
    const {
      type: iconType,
      euiVarColor
    } = treeViewIconProps;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasRightArrow && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      css: styles.breadcrumbRightIcon,
      type: "arrowRight",
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: tooltip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `kubernetesSecurityBreadcrumbIcon-${collectionType}`,
      iconType: iconType,
      css: styles.breadcrumbIconColor(euiVars[euiVarColor]),
      "aria-label": `Click ${clusterLevel} breadcrumb`,
      onClick: onBreadCrumbClick(collectionType)
    })), showBreadcrumbText && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: tooltip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      css: isBolded ? styles.breadcrumbButtonBold : styles.breadcrumbButton,
      color: "text",
      onClick: onBreadCrumbClick(collectionType)
    }, resourceName)));
  }, [onBreadCrumbClick, styles, treeNavSelection, euiVars]);
  if (!treeNavSelection.clusterId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.breadcrumb
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.breadcrumbsWrapper
  }, renderBreadcrumbLink(_types.KubernetesTreeViewLevels.clusterId, _helpers.KUBERNETES_COLLECTION_ICONS_PROPS.clusterId, !(treeNavSelection.namespace || treeNavSelection.node), false), treeNavSelection.namespace && renderBreadcrumbLink(_types.KubernetesTreeViewLevels.namespace, _helpers.KUBERNETES_COLLECTION_ICONS_PROPS.namespace, !treeNavSelection.pod), treeNavSelection.node && renderBreadcrumbLink(_types.KubernetesTreeViewLevels.node, _helpers.KUBERNETES_COLLECTION_ICONS_PROPS.node, !treeNavSelection.pod), treeNavSelection.pod && renderBreadcrumbLink(_types.KubernetesTreeViewLevels.pod, _helpers.KUBERNETES_COLLECTION_ICONS_PROPS.pod, !treeNavSelection.containerImage), treeNavSelection.containerImage && renderBreadcrumbLink(_types.KubernetesTreeViewLevels.containerImage, _helpers.KUBERNETES_COLLECTION_ICONS_PROPS.containerImage, true))));
};
exports.Breadcrumb = Breadcrumb;