"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      size,
      font,
      border
    } = euiTheme;
    const container = {
      padding: size.base,
      border: border.thin,
      borderRadius: border.radius.medium,
      overflow: 'auto',
      position: 'relative',
      height: '100%'
    };
    const title = {
      marginBottom: size.s,
      fontSize: size.m,
      fontWeight: font.weight.bold,
      whiteSpace: 'nowrap'
    };
    const dataInfo = {
      fontSize: `calc(${size.l} - ${size.xxs})`,
      lineHeight: size.l,
      fontWeight: font.weight.bold
    };
    const dataValue = {
      fontWeight: font.weight.semiBold,
      marginLeft: 'auto'
    };
    const filters = {
      marginLeft: size.s
    };
    const loadingSpinner = {
      alignItems: 'center',
      margin: `${size.xs} auto ${size.xl} auto`
    };
    return {
      container,
      title,
      dataInfo,
      dataValue,
      filters,
      loadingSpinner
    };
  }, [euiTheme]);
  return cached;
};
exports.useStyles = useStyles;