"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchCountWidgetData = void 0;
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchCountWidgetData = (widgetKey, filterQuery, groupedBy, index) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const cachingKeys = [_constants.QUERY_KEY_COUNT_WIDGET, widgetKey, filterQuery, groupedBy, index];
  const query = (0, _reactQuery.useInfiniteQuery)(cachingKeys, async () => {
    const res = await http.get(_constants.COUNT_ROUTE, {
      version: _constants.CURRENT_API_VERSION,
      query: {
        query: filterQuery,
        field: groupedBy,
        index
      }
    });
    return res;
  }, {
    refetchOnWindowFocus: false,
    refetchOnMount: false,
    refetchOnReconnect: false
  });
  return query;
};
exports.useFetchCountWidgetData = useFetchCountWidgetData;