"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyValueTable = KeyValueTable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _formatted_value = require("./formatted_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function KeyValueTable({
  keyValuePairs,
  tableProps = {}
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, (0, _extends2.default)({
    compressed: true
  }, tableProps), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, keyValuePairs.map(({
    key,
    value
  }) => {
    const asArray = (0, _lodash.castArray)(value);
    const valueList = asArray.length <= 1 ? /*#__PURE__*/_react.default.createElement(_formatted_value.FormattedValue, {
      value: asArray[0]
    }) : /*#__PURE__*/_react.default.createElement("ul", null, asArray.map((val, index) => /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_formatted_value.FormattedValue, {
      key: index,
      value: val
    }))));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
      key: key
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "dot-key"
    }, key)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      "data-test-subj": "value"
    }, valueList));
  })));
}