"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterceptTelemetry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _event_definitions = require("./event_definitions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InterceptTelemetry {
  constructor() {
    (0, _defineProperty2.default)(this, "reportEvent", void 0);
  }
  setup({
    analytics
  }) {
    _event_definitions.eventTypes.forEach(eventType => {
      analytics.registerEventType(eventType);
    });
    return {};
  }
  start({
    analytics
  }) {
    this.reportEvent = analytics.reportEvent;
    return {
      reportInterceptRegistration: this.reportInterceptRegistration.bind(this),
      reportInterceptOverload: this.reportInterceptOverload.bind(this),
      reportInterceptInteraction: this.reportInterceptInteraction.bind(this)
    };
  }
  reportInterceptRegistration({
    interceptId
  }) {
    var _this$reportEvent;
    (_this$reportEvent = this.reportEvent) === null || _this$reportEvent === void 0 ? void 0 : _this$reportEvent.call(this, _event_definitions.EventMetric.INTERCEPT_REGISTRATION, {
      [_event_definitions.EventFieldType.INTERCEPT_ID]: interceptId
    });
  }
  reportInterceptOverload({
    interceptId
  }) {
    var _this$reportEvent2;
    (_this$reportEvent2 = this.reportEvent) === null || _this$reportEvent2 === void 0 ? void 0 : _this$reportEvent2.call(this, _event_definitions.EventMetric.INTERCEPT_OVERLOAD, {
      [_event_definitions.EventFieldType.INTERCEPT_ID]: interceptId
    });
  }
  reportInterceptInteraction({
    interactionDuration,
    interactionType,
    interceptId
  }) {
    var _this$reportEvent3;
    (_this$reportEvent3 = this.reportEvent) === null || _this$reportEvent3 === void 0 ? void 0 : _this$reportEvent3.call(this, _event_definitions.EventMetric.INTERCEPT_TERMINATION_INTERACTION, {
      [_event_definitions.EventFieldType.INTERACTION_TYPE]: interactionType,
      [_event_definitions.EventFieldType.INTERCEPT_ID]: interceptId,
      [_event_definitions.EventFieldType.INTERACTION_DURATION]: interactionDuration
    });
  }
}
exports.InterceptTelemetry = InterceptTelemetry;