"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationAssistantPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../common/constants");
var _routes = require("./routes");
var _experimental_features = require("../common/experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IntegrationAssistantPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "isAvailable", void 0);
    (0, _defineProperty2.default)(this, "hasLicense", void 0);
    this.logger = initializerContext.logger.get();
    this.config = initializerContext.config.get();
    this.isAvailable = true;
    this.hasLicense = false;
  }
  setup(core) {
    var _this$config$enableEx;
    core.http.registerRouteHandlerContext('integrationAssistant', () => ({
      getStartServices: core.getStartServices,
      isAvailable: () => this.isAvailable && this.hasLicense,
      logger: this.logger
    }));
    const router = core.http.createRouter();
    const experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)((_this$config$enableEx = this.config.enableExperimental) !== null && _this$config$enableEx !== void 0 ? _this$config$enableEx : []);
    this.logger.debug('integrationAssistant api: Setup');
    (0, _routes.registerRoutes)(router, experimentalFeatures);
    return {
      setIsAvailable: isAvailable => {
        if (!isAvailable) {
          this.isAvailable = false;
        }
      }
    };
  }
  start(_, dependencies) {
    this.logger.debug('integrationAssistant api: Started');
    const {
      licensing
    } = dependencies;
    licensing.license$.subscribe(license => {
      this.hasLicense = license.hasAtLeast(_constants.MINIMUM_LICENSE_TYPE);
    });
    return {};
  }
  stop() {}
}
exports.IntegrationAssistantPlugin = IntegrationAssistantPlugin;