"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BuildIntegrationError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BuildIntegrationError extends Error {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "errorCode", _constants.GenerationErrorCode.BUILD_INTEGRATION_ERROR);
  }
  sendResponse(res) {
    return res.badRequest({
      body: {
        message: this.message,
        attributes: {
          errorCode: this.errorCode
        }
      }
    });
  }
}
exports.BuildIntegrationError = BuildIntegrationError;