"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFieldMapping = createFieldMapping;
var _nunjucks = _interopRequireDefault(require("nunjucks"));
var _jsYaml = require("js-yaml");
var _util = require("../util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createFieldMapping(packageName, dataStreamName, specificDataStreamDir, docs) {
  const dataStreamFieldsDir = `${specificDataStreamDir}/fields`;
  const baseFields = createBaseFields(dataStreamFieldsDir, packageName, dataStreamName);
  const customFields = createCustomFields(dataStreamFieldsDir, docs);
  return [...baseFields, ...customFields];
}
function createBaseFields(dataStreamFieldsDir, packageName, dataStreamName) {
  const datasetName = `${packageName}.${dataStreamName}`;
  const baseFields = _nunjucks.default.render('base_fields.yml.njk', {
    module: packageName,
    dataset: datasetName
  });
  (0, _util.createSync)(`${dataStreamFieldsDir}/base-fields.yml`, baseFields);
  return (0, _jsYaml.load)(baseFields);
}
function createCustomFields(dataStreamFieldsDir, pipelineResults) {
  const mergedResults = (0, _util.mergeSamples)(pipelineResults);
  const fieldKeys = (0, _util.generateFields)(mergedResults);
  (0, _util.createSync)(`${dataStreamFieldsDir}/fields.yml`, fieldKeys);
  return (0, _jsYaml.load)(fieldKeys);
}