"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleInvalidCategorization = handleInvalidCategorization;
var _output_parsers = require("@langchain/core/output_parsers");
var _processors = require("../../util/processors");
var _constants = require("./constants");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleInvalidCategorization({
  state,
  model
}) {
  const categorizationInvalidPrompt = _prompts.CATEGORIZATION_VALIDATION_PROMPT;
  const outputParser = new _output_parsers.JsonOutputParser();
  const categorizationInvalidGraph = categorizationInvalidPrompt.pipe(model).pipe(outputParser);
  const currentProcessors = await categorizationInvalidGraph.invoke({
    current_processors: JSON.stringify(state.currentProcessors, null, 2),
    invalid_categorization: JSON.stringify(state.invalidCategorization, null, 2),
    ex_answer: state.exAnswer,
    compatible_types: JSON.stringify(_constants.ECS_EVENT_TYPES_PER_CATEGORY, null, 2)
  });
  const processors = {
    type: 'categorization',
    processors: currentProcessors
  };
  const currentPipeline = (0, _processors.combineProcessors)(state.initialPipeline, processors);
  return {
    currentPipeline,
    currentProcessors,
    lastExecutedChain: 'invalidCategorization'
  };
}