"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeployStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _filesaver = require("@elastic/filesaver");
var _section_wrapper = require("../../../../../common/components/section_wrapper");
var _success_section = require("../../../../../common/components/success_section");
var _use_deploy_integration = require("./use_deploy_integration");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped library

const DeployStep = exports.DeployStep = /*#__PURE__*/_react.default.memo(({
  integrationSettings,
  result,
  celInputResult,
  connector
}) => {
  const {
    isLoading,
    error,
    integrationFile,
    integrationName
  } = (0, _use_deploy_integration.useDeployIntegration)({
    integrationSettings,
    result,
    celInputResult,
    connector
  });
  const onSaveZip = (0, _react.useCallback)(() => {
    (0, _filesaver.saveAs)(integrationFile, `${integrationName !== null && integrationName !== void 0 ? integrationName : 'custom_integration'}.zip`);
  }, [integrationFile, integrationName]);
  if (isLoading || error) {
    return /*#__PURE__*/_react.default.createElement(_section_wrapper.SectionWrapper, {
      title: i18n.DEPLOYING
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      "data-test-subj": "deployStep-loading"
    }), error && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      size: "s",
      "data-test-subj": "deployStep-error"
    }, error))));
  }
  if (integrationName) {
    return /*#__PURE__*/_react.default.createElement(_success_section.SuccessSection, {
      integrationName: integrationName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true,
      paddingSize: "l",
      "data-test-subj": "deployStep-success"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "flexStart",
      justifyContent: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        marginTop: '3px'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "download",
      color: "primary",
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, i18n.DOWNLOAD_ZIP_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, i18n.DOWNLOAD_ZIP_DESCRIPTION)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: onSaveZip,
      "data-test-subj": "saveZipButton"
    }, i18n.DOWNLOAD_ZIP_LINK)))));
  }
  return null;
});
DeployStep.displayName = 'DeployStep';