"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOCAL_CLUSTER_KEY = void 0;
exports.getLocalClusterDetails = getLocalClusterDetails;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LOCAL_CLUSTER_KEY = exports.LOCAL_CLUSTER_KEY = '(local)';
function getLocalClusterStatus(rawResponse) {
  var _rawResponse$_shards;
  if (((_rawResponse$_shards = rawResponse._shards) === null || _rawResponse$_shards === void 0 ? void 0 : _rawResponse$_shards.successful) === 0) {
    return 'failed';
  }
  if (rawResponse.timed_out || rawResponse._shards.failed) {
    return 'partial';
  }
  return 'successful';
}
function getLocalClusterDetails(rawResponse) {
  const shards = {
    ...rawResponse._shards
  };
  delete shards.failures;
  return {
    status: getLocalClusterStatus(rawResponse),
    indices: '',
    took: rawResponse.took,
    timed_out: rawResponse.timed_out,
    _shards: shards,
    failures: rawResponse._shards.failures
  };
}