"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeFilterManager = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _esQuery = require("@kbn/es-query");
var _filter_manager = require("./filter_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Convert slider value into ES range filter
function toRange(sliderValue) {
  return {
    gte: sliderValue.min,
    lte: sliderValue.max
  };
}

// Convert ES range filter into slider value
function fromRange(range) {
  const sliderValue = {};
  if (_lodash.default.has(range, 'gte')) {
    sliderValue.min = _lodash.default.get(range, 'gte');
  }
  if (_lodash.default.has(range, 'gt')) {
    sliderValue.min = _lodash.default.get(range, 'gt');
  }
  if (_lodash.default.has(range, 'lte')) {
    sliderValue.max = _lodash.default.get(range, 'lte');
  }
  if (_lodash.default.has(range, 'lt')) {
    sliderValue.max = _lodash.default.get(range, 'lt');
  }
  return sliderValue;
}
class RangeFilterManager extends _filter_manager.FilterManager {
  /**
   * Convert slider value into filter
   *
   * @param {object} react-input-range value - POJO with `min` and `max` properties
   * @return {object} range filter
   */
  createFilter(value) {
    const indexPattern = this.getIndexPattern();
    const newFilter = (0, _esQuery.buildRangeFilter)(indexPattern.fields.getByName(this.fieldName), toRange(value), indexPattern);
    newFilter.meta.key = this.fieldName;
    newFilter.meta.controlledBy = this.controlId;
    return newFilter;
  }
  getValueFromFilterBar() {
    const kbnFilters = this.findFilters();
    if (kbnFilters.length === 0) {
      return;
    }
    let range;
    if (_lodash.default.has(kbnFilters[0], 'query.script')) {
      range = _lodash.default.get(kbnFilters[0], 'query.script.script.params');
    } else {
      range = _lodash.default.get(kbnFilters[0], ['query', 'range', this.fieldName]);
    }
    if (!range) {
      return;
    }
    return fromRange(range);
  }
}
exports.RangeFilterManager = RangeFilterManager;