"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getControlFactory = getControlFactory;
var _range_control_factory = require("./range_control_factory");
var _list_control_factory = require("./list_control_factory");
var _editor_utils = require("../editor_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getControlFactory(controlParams) {
  let factory = null;
  switch (controlParams.type) {
    case _editor_utils.CONTROL_TYPES.RANGE:
      factory = _range_control_factory.rangeControlFactory;
      break;
    case _editor_utils.CONTROL_TYPES.LIST:
      factory = _list_control_factory.listControlFactory;
      break;
    default:
      throw new Error(`Unhandled control type ${controlParams.type}`);
  }
  return factory;
}