"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestPipelinesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../common/constants");
var _services = require("./application/services");
var _locator = require("./locator");
var _ingest_pipeline_flyout_embeddable = require("./application/sections/pipelines_list/ingest_pipeline_flyout_embeddable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class IngestPipelinesPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "license", null);
    (0, _defineProperty2.default)(this, "licensingSubscription", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = initializerContext.config.get();
  }
  setup(coreSetup, plugins) {
    const {
      management,
      usageCollection,
      share
    } = plugins;
    const {
      http,
      getStartServices
    } = coreSetup;

    // Initialize services
    _services.uiMetricService.setup(usageCollection);
    _services.apiService.setup(http, _services.uiMetricService);
    const pluginName = _i18n.i18n.translate('xpack.ingestPipelines.appTitle', {
      defaultMessage: 'Ingest Pipelines'
    });
    management.sections.section.ingest.registerApp({
      id: _constants.PLUGIN_ID,
      order: 1,
      title: pluginName,
      mount: async params => {
        const [coreStart] = await getStartServices();
        const {
          chrome: {
            docTitle
          }
        } = coreStart;
        docTitle.change(pluginName);
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_management_section')));
        const unmountAppCallback = await mountManagementSection(coreSetup, {
          ...params,
          license: this.license,
          config: {
            enableManageProcessors: this.config.enableManageProcessors !== false
          }
        });
        return () => {
          docTitle.reset();
          unmountAppCallback();
        };
      }
    });
    share.url.locators.create(new _locator.IngestPipelinesLocatorDefinition({
      managementAppLocator: management.locator
    }));
  }
  start(core, startDependencies) {
    var _startDependencies$li;
    this.licensingSubscription = (_startDependencies$li = startDependencies.licensing) === null || _startDependencies$li === void 0 ? void 0 : _startDependencies$li.license$.subscribe(license => {
      this.license = license;
    });
    return {
      getIngestPipelineFlyoutComponent: deps => {
        const {
          docLinks,
          application,
          executionContext,
          overlays,
          notifications
        } = core;
        _services.documentationService.setup(docLinks);
        // disable breadcrumb service for the flyout
        _services.breadcrumbService.setup(() => {});
        const services = {
          breadcrumbs: _services.breadcrumbService,
          metric: _services.uiMetricService,
          documentation: _services.documentationService,
          api: _services.apiService,
          fileReader: _services.fileReaderService,
          notifications,
          history: deps.history,
          uiSettings: core.uiSettings,
          settings: core.settings,
          share: startDependencies.share,
          fileUpload: startDependencies.fileUpload,
          application,
          executionContext,
          license: this.license,
          consolePlugin: startDependencies.console,
          overlays,
          http: core.http,
          config: {
            enableManageProcessors: this.config.enableManageProcessors !== false
          }
        };
        return props => {
          return /*#__PURE__*/_react.default.createElement(_ingest_pipeline_flyout_embeddable.IngestPipelineFlyout, {
            services,
            coreServices: core,
            ...props
          });
        };
      }
    };
  }
  stop() {
    var _this$licensingSubscr;
    (_this$licensingSubscr = this.licensingSubscription) === null || _this$licensingSubscr === void 0 ? void 0 : _this$licensingSubscr.unsubscribe();
  }
}
exports.IngestPipelinesPlugin = IngestPipelinesPlugin;