"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizePipelineNameFromParams = void 0;
var _shared_imports = require("../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const normalizePipelineNameFromParams = nameFromRouterParams => {
  if (window.location.pathname.endsWith(nameFromRouterParams)) {
    return (0, _shared_imports.attemptToURIDecode)(nameFromRouterParams);
  }

  // this is a temporary workaround because history v4
  // decodes pathname special characters incorrectly
  // see https://github.com/elastic/kibana/issues/234500
  return (0, _shared_imports.attemptToURIDecode)(window.location.pathname.split('/').pop());
};
exports.normalizePipelineNameFromParams = normalizePipelineNameFromParams;