"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toKnownError = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _function = require("fp-ts/lib/function");
var _Either = require("fp-ts/lib/Either");
var _i18n_texts = require("./i18n_texts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is a runtime type (RT) for an error node which is a recursive type
const errorNodeRT = t.recursion('ErrorNode', ErrorNode => t.intersection([t.interface({
  reason: t.string
}), t.partial({
  processor_type: t.string,
  suppressed: t.array(ErrorNode)
})]));

// This is a runtime type for the attributes object we expect to receive from the server
// for processor errors
const errorAttributesObjectRT = t.interface({
  attributes: t.interface({
    error: t.interface({
      root_cause: t.array(errorNodeRT)
    })
  })
});
const isProcessorsError = (0, _function.flow)(errorAttributesObjectRT.decode, _Either.isRight);
const flattenErrorsTree = node => {
  const result = [];
  const recurse = _node => {
    result.push({
      reason: _node.reason,
      processorType: _node.processor_type
    });
    if (_node.suppressed && Array.isArray(_node.suppressed)) {
      _node.suppressed.forEach(recurse);
    }
  };
  recurse(node);
  return result;
};
const toKnownError = error => {
  if (typeof error === 'object' && error != null && isProcessorsError(error)) {
    const errorAttributes = error;
    const rootCause = errorAttributes.attributes.error.root_cause[0];
    return {
      errors: flattenErrorsTree(rootCause)
    };
  }
  if (typeof error === 'string') {
    return {
      errors: [{
        reason: error
      }]
    };
  }
  if (error instanceof Error || typeof error === 'object' && error != null && error.message) {
    return {
      errors: [{
        reason: error.message
      }]
    };
  }
  return {
    errors: [{
      reason: _i18n_texts.i18nTexts.errors.unknownError
    }]
  };
};
exports.toKnownError = toKnownError;