"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTestPipelineContext = exports.reducer = exports.TestPipelineContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../shared_imports");
var _deserialize = require("../deserialize");
var _serialize = require("../serialize");
var _use_is_mounted = require("../use_is_mounted");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TEST_PIPELINE_CONTEXT = {
  testPipelineData: {
    config: {
      selectedDocumentIndex: 0
    },
    isExecutingPipeline: false
  },
  testPipelineDataDispatch: () => {},
  updateTestOutputPerProcessor: () => {}
};
const TestPipelineContext = /*#__PURE__*/_react.default.createContext(DEFAULT_TEST_PIPELINE_CONTEXT);
const useTestPipelineContext = () => {
  const ctx = (0, _react.useContext)(TestPipelineContext);
  if (!ctx) {
    throw new Error('"useTestPipelineContext" can only be called inside of TestPipelineContextProvider.Provider!');
  }
  return ctx;
};
exports.useTestPipelineContext = useTestPipelineContext;
const reducer = (state, action) => {
  if (action.type === 'updateOutputPerProcessor') {
    return {
      ...state,
      testOutputPerProcessor: action.payload.testOutputPerProcessor,
      isExecutingPipeline: false
    };
  }
  if (action.type === 'updateConfig') {
    return {
      ...action.payload,
      config: {
        ...action.payload.config,
        selectedDocumentIndex: state.config.selectedDocumentIndex
      },
      testOutputPerProcessor: state.testOutputPerProcessor
    };
  }
  if (action.type === 'updateActiveDocument') {
    return {
      ...state,
      config: {
        ...state.config,
        selectedDocumentIndex: action.payload.config.selectedDocumentIndex
      }
    };
  }
  if (action.type === 'updateIsExecutingPipeline') {
    return {
      ...state,
      isExecutingPipeline: action.payload.isExecutingPipeline
    };
  }
  if (action.type === 'reset') {
    return DEFAULT_TEST_PIPELINE_CONTEXT.testPipelineData;
  }
  return state;
};
exports.reducer = reducer;
const TestPipelineContextProvider = ({
  children
}) => {
  const [state, dispatch] = (0, _react.useReducer)(reducer, DEFAULT_TEST_PIPELINE_CONTEXT.testPipelineData);
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const isMounted = (0, _use_is_mounted.useIsMounted)();
  const updateTestOutputPerProcessor = (0, _react.useCallback)(async (documents, processors) => {
    if (!documents) {
      return;
    }
    dispatch({
      type: 'updateIsExecutingPipeline',
      payload: {
        isExecutingPipeline: true
      }
    });
    const serializedProcessorsWithTag = (0, _serialize.serialize)({
      pipeline: {
        processors: processors.processors,
        onFailure: processors.onFailure
      },
      copyIdToTag: true
    });
    const {
      data: verboseResults,
      error
    } = await services.api.simulatePipeline({
      documents,
      verbose: true,
      pipeline: {
        ...serializedProcessorsWithTag
      }
    });
    if (!isMounted.current) {
      return;
    }
    if (error) {
      dispatch({
        type: 'updateOutputPerProcessor',
        payload: {
          isExecutingPipeline: false,
          // reset the output if there is an error
          // this will result to the status changing to "inactive"
          testOutputPerProcessor: undefined
        }
      });
      services.notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.ingestPipelines.testPipeline.errorNotificationText', {
          defaultMessage: 'Error executing pipeline'
        })
      });
      return;
    }
    dispatch({
      type: 'updateOutputPerProcessor',
      payload: {
        testOutputPerProcessor: (0, _deserialize.deserializeVerboseTestOutput)(verboseResults),
        isExecutingPipeline: false
      }
    });
  }, [isMounted, services.api, services.notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement(TestPipelineContext.Provider, {
    value: {
      testPipelineData: state,
      testPipelineDataDispatch: dispatch,
      updateTestOutputPerProcessor
    }
  }, children);
};
exports.TestPipelineContextProvider = TestPipelineContextProvider;