"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorsTree = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("../../constants");
var _utils = require("../../utils");
var _add_processor_button = require("../add_processor_button");
var _components = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    container: (0, _react2.css)`
      padding: ${euiTheme.size.s};
    `
  };
};

/**
 * This component is the public interface to our optimised tree rendering private components and
 * also contains top-level state concerns for an instance of the component
 */
const ProcessorsTree = exports.ProcessorsTree = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    processors,
    baseSelector,
    onAction,
    movingProcessor
  } = props;
  const styles = useStyles();
  // These refs are created here so they can be shared with all
  // recursively rendered trees. Their values should come from react-virtualized
  // List component and WindowScroller component.
  const windowScrollerRef = (0, _react.useRef)(null);
  const listRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    const cancelMoveKbListener = event => {
      // x-browser support per https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/keyCode
      if (event.key === _eui.keys.ESCAPE || event.code === 'Escape') {
        onAction({
          type: 'cancelMove'
        });
      }
    };
    const cancelMoveClickListener = () => {
      onAction({
        type: 'cancelMove'
      });
    };
    // Give the browser a chance to flush any click events including the click
    // event that triggered any state transition into selecting a processor to move
    setTimeout(() => {
      if (movingProcessor) {
        window.addEventListener('keyup', cancelMoveKbListener);
        window.addEventListener('click', cancelMoveClickListener);
      } else {
        window.removeEventListener('keyup', cancelMoveKbListener);
        window.removeEventListener('click', cancelMoveClickListener);
      }
    });
    return () => {
      window.removeEventListener('keyup', cancelMoveKbListener);
      window.removeEventListener('click', cancelMoveClickListener);
    };
  }, [movingProcessor, onAction]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": props['data-test-subj'],
    direction: "column",
    gutterSize: "none",
    responsive: false,
    css: styles.container
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.PrivateTree, {
    windowScrollerRef: windowScrollerRef,
    listRef: listRef,
    level: 1,
    onAction: onAction,
    movingProcessor: movingProcessor,
    processors: processors,
    selector: baseSelector
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": (0, _utils.selectorToDataTestSubject)(baseSelector),
    responsive: false,
    alignItems: "flexStart",
    gutterSize: "none",
    direction: "column"
  }, !processors.length &&
  /*#__PURE__*/
  // We want to make this dropzone the max length of its container
  _react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_components.DropZoneButton, {
    "data-test-subj": "dropButtonEmptyTree",
    isVisible: Boolean(movingProcessor),
    isDisabled: false,
    onClick: event => {
      event.preventDefault();
      onAction({
        type: 'move',
        payload: {
          destination: baseSelector.concat(_constants.DropSpecialLocations.top),
          source: movingProcessor.selector
        }
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_processor_button.AddProcessorButton, {
    onClick: () => {
      onAction({
        type: 'addProcessor',
        payload: {
          target: baseSelector
        }
      });
    },
    renderButtonAsLink: true
  })))));
});