"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetSecurityUser = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _field_name_field = require("./common_fields/field_name_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const userProperties = ['username', 'roles', 'email', 'full_name', 'metadata', 'api_key', 'realm', 'authentication_type'];
const comboBoxOptions = userProperties.map(prop => ({
  label: prop
}));
const helpTextValues = userProperties.join(', ');
const fieldsConfig = {
  /* Optional fields config */
  properties: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: _shared.to.arrayOfStrings,
    serializer: _shared.from.optionalArrayOfStrings,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setSecurityUserForm.propertiesFieldLabel', {
      defaultMessage: 'Properties (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.setForm.propertiesFieldHelpText",
      defaultMessage: "User details to add. Defaults to: {value}",
      values: {
        value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "[", helpTextValues, "]")
      }
    })
  }
};
const SetSecurityUser = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setSecurityUserForm.fieldNameField', {
      defaultMessage: 'Output field.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.properties,
    component: _shared_imports.ComboBoxField,
    componentProps: {
      euiFieldProps: {
        options: comboBoxOptions,
        noSuggestions: false
      }
    },
    path: "fields.properties"
  }));
};
exports.SetSecurityUser = SetSecurityUser;