"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Rename = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const Rename = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.renameForm.fieldNameHelpText', {
      defaultMessage: 'Field to rename.'
    })
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.renameForm.targetFieldLabel', {
      defaultMessage: 'Target field'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.renameForm.targetFieldHelpText', {
      defaultMessage: 'New field name. This field cannot already exist.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.renameForm.targetFieldRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }]
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, null));
};
exports.Rename = Rename;