"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoIP = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _shared = require("./shared");
var _target_field = require("./common_fields/target_field");
var _properties_field = require("./common_fields/properties_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldsConfig = {
  /* Optional field config */
  database_file: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: v => v === 'GeoLite2-City.mmdb' || v === '' ? undefined : v,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoIPForm.databaseFileLabel', {
      defaultMessage: 'Database file (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.geoIPForm.databaseFileHelpText",
      defaultMessage: "GeoIP2 database file in the {ingestGeoIP} configuration directory. Defaults to {databaseFile}.",
      values: {
        databaseFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'GeoLite2-City.mmdb'),
        ingestGeoIP: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'ingest-geoip')
      }
    })
  },
  first_only: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: true,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(true),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoIPForm.firstOnlyFieldLabel', {
      defaultMessage: 'First only'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoIPForm.firstOnlyFieldHelpText', {
      defaultMessage: 'Use the first matching geo data, even if the field contains an array.'
    })
  }
};
const GeoIP = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoIPForm.fieldNameHelpText', {
      defaultMessage: 'Field containing an IP address for the geographical lookup.'
    })
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoIPForm.targetFieldHelpText', {
      defaultMessage: 'Field used to contain geo data properties.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.Field,
    config: fieldsConfig.database_file,
    path: "fields.database_file"
  }), /*#__PURE__*/_react.default.createElement(_properties_field.PropertiesField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoIPForm.propertiesFieldHelpText', {
      defaultMessage: 'Properties added to the target field. Valid properties depend on the database file used.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.ToggleField,
    config: fieldsConfig.first_only,
    path: "fields.first_only"
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, null));
};
exports.GeoIP = GeoIP;