"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorOutput = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("../../shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  tabDescription: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.descriptionText', {
    defaultMessage: 'Preview changes to the test document.'
  }),
  skippedCalloutTitle: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.skippedCalloutTitle', {
    defaultMessage: 'The processor was not run.'
  }),
  droppedCalloutTitle: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.droppedCalloutTitle', {
    defaultMessage: 'The document was dropped.'
  }),
  noOutputCalloutTitle: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.noOutputCalloutTitle', {
    defaultMessage: 'Output is not available for this processor.'
  }),
  processorOutputLabel: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.processorOutputCodeBlockLabel', {
    defaultMessage: 'Data out'
  }),
  processorErrorTitle: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.processorErrorCodeBlockLabel', {
    defaultMessage: 'There was an error'
  }),
  prevProcessorLabel: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.processorInputCodeBlockLabel', {
    defaultMessage: 'Data in'
  }),
  processorIgnoredErrorTitle: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.ignoredErrorCodeBlockLabel', {
    defaultMessage: 'There was an ignored error'
  }),
  documentsDropdownLabel: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.documentsDropdownLabel', {
    defaultMessage: 'Test data:'
  }),
  loadingMessage: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.loadingMessage', {
    defaultMessage: 'Loading processor output…'
  })
};
const styles = {
  callOut: (0, _react2.css)`
    & .euiCallOutHeader {
      align-items: center;
    }
  `,
  codeBlock: (0, _react2.css)`
    & > pre {
      background: transparent;
    }
  `
};
const ProcessorOutput = ({
  processorOutput,
  documents,
  selectedDocumentIndex,
  updateSelectedDocument,
  isExecuting
}) => {
  if (isExecuting) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      inline: true
    }, i18nTexts.loadingMessage);
  }
  if (!processorOutput) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18nTexts.noOutputCalloutTitle,
      color: "danger",
      iconType: "warning"
    });
  }
  const {
    processorInput,
    doc: currentResult,
    ignored_error: ignoredError,
    error,
    status
  } = processorOutput;
  const NoOutputCallOut = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.noOutputCalloutTitle,
    iconType: "pin"
  });
  const getOutputContent = () => {
    switch (status) {
      case 'skipped':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          title: i18nTexts.skippedCalloutTitle,
          iconType: _shared.SkippedIcon,
          css: styles.callOut
        });
      case 'dropped':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          title: i18nTexts.droppedCalloutTitle,
          iconType: "indexClose"
        });
      case 'success':
        if (currentResult) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
            paddingSize: "s",
            language: "json",
            isCopyable: true
          }, JSON.stringify(currentResult, null, 2));
        }
        return /*#__PURE__*/_react.default.createElement(NoOutputCallOut, null);
      case 'error':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          iconType: _shared.ErrorIcon,
          title: i18nTexts.processorErrorTitle,
          color: "danger",
          css: styles.callOut
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          language: "json",
          paddingSize: "none",
          css: styles.codeBlock,
          transparentBackground: true
        }, JSON.stringify(error, null, 2)));
      case 'error_ignored':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          iconType: _shared.ErrorIgnoredIcon,
          title: i18nTexts.processorIgnoredErrorTitle,
          color: "warning",
          css: styles.callOut
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          css: styles.codeBlock,
          language: "json",
          paddingSize: "none",
          transparentBackground: true
        }, JSON.stringify(ignoredError, null, 2)));
      default:
        return /*#__PURE__*/_react.default.createElement(NoOutputCallOut, null);
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "processorOutputTabContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.tabDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    options: documents.map((doc, index) => ({
      value: index,
      text: _i18n.i18n.translate('xpack.ingestPipelines.processorOutput.documentLabel', {
        defaultMessage: 'Document {number}',
        values: {
          number: index + 1
        }
      })
    })),
    value: selectedDocumentIndex,
    onChange: e => {
      updateSelectedDocument(Number(e.target.value));
    },
    "aria-label": i18nTexts.documentsDropdownLabel,
    prepend: i18nTexts.documentsDropdownLabel
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "processor_input_accordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.prevProcessorLabel))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    paddingSize: "s",
    language: "json",
    isCopyable: true
  }, JSON.stringify(processorInput ? processorInput : documents[selectedDocumentIndex], null, 2)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("span", null, i18nTexts.processorOutputLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), getOutputContent());
};
exports.ProcessorOutput = ProcessorOutput;