"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DragAndDropTextList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  removeItemButtonAriaLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dragAndDropList.removeItemLabel', {
    defaultMessage: 'Remove item'
  })
};
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    labelContainer: (0, _react2.css)`
      margin-bottom: ${euiTheme.size.xs};
    `,
    panel: (0, _react2.css)`
      background-color: ${euiTheme.colors.lightestShade};
      padding: ${euiTheme.size.m};
    `,
    item: (0, _react2.css)`
      background-color: ${euiTheme.colors.lightestShade};
      padding-top: ${euiTheme.size.s};
      padding-bottom: ${euiTheme.size.s};
    `,
    grabIcon: (0, _react2.css)`
      height: ${euiTheme.size.xl};
      width: ${euiTheme.size.xl};
      display: flex;
      align-items: center;
      justify-content: center;
    `,
    removeButton: (0, _react2.css)`
      margin-left: ${euiTheme.size.s};
    `
  };
};
function DragAndDropTextListComponent({
  label,
  helpText,
  error,
  value,
  onMove,
  onAdd,
  onRemove,
  addLabel,
  textValidations,
  textDeserializer,
  textSerializer
}) {
  const styles = useStyles();
  const [droppableId] = (0, _react.useState)(() => (0, _uuid.v4)());
  const [firstItemId] = (0, _react.useState)(() => (0, _uuid.v4)());
  const onDragEnd = (0, _react.useCallback)(({
    source,
    destination
  }) => {
    if (source && destination) {
      onMove(source.index, destination.index);
    }
  }, [onMove]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: typeof error === 'string',
    error: error,
    fullWidth: true,
    "data-test-subj": "droppableList"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.labelContainer,
    justifyContent: "flexStart",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: firstItemId
  }, /*#__PURE__*/_react.default.createElement("strong", null, label)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, helpText)))), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.panel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: droppableId
  }, value.map((item, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
      customDragHandle: true,
      spacing: "none",
      draggableId: String(item.id),
      index: idx,
      key: item.id
    }, provided => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        css: styles.item,
        justifyContent: "center",
        gutterSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, provided.dragHandleProps, {
        css: styles.grabIcon
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "grab"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
        path: item.path,
        config: {
          validations: textValidations ? textValidations.map(validator => ({
            validator
          })) : undefined,
          deserializer: textDeserializer,
          serializer: textSerializer
        },
        readDefaultValueOnForm: !item.isNew
      }, field => {
        const {
          isInvalid,
          errorMessage
        } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          isInvalid: isInvalid,
          error: errorMessage,
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          "data-test-subj": `input-${idx}`,
          id: idx === 0 ? firstItemId : undefined,
          isInvalid: isInvalid,
          value: field.value,
          onChange: field.onChange,
          compressed: true,
          fullWidth: true
        }));
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, value.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": i18nTexts.removeItemButtonAriaLabel,
        css: styles.removeButton,
        iconType: "minusInCircle",
        color: "danger",
        onClick: () => onRemove(item.id),
        size: "s"
      }) :
      /*#__PURE__*/
      // Render a no-op placeholder button
      _react.default.createElement(_eui.EuiIcon, {
        css: styles.removeButton,
        type: "empty"
      })));
    });
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    onClick: onAdd,
    "data-test-subj": "addButton"
  }, addLabel))));
}
const DragAndDropTextList = exports.DragAndDropTextList = /*#__PURE__*/(0, _react.memo)(DragAndDropTextListComponent);