"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initFindMetricsExplorerViewRoute = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _latest = require("../../../common/http_api/latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NON_STARTED_SERVICE_ERROR = {
  statusCode: 500,
  body: {
    message: `Handler for "GET ${_latest.METRICS_EXPLORER_VIEW_URL}" was registered but MetricsViewService has not started.`
  }
};
const initFindMetricsExplorerViewRoute = ({
  framework,
  getStartServices
}) => {
  framework.registerRoute({
    method: 'get',
    path: _latest.METRICS_EXPLORER_VIEW_URL,
    validate: {
      query: (0, _ioTsUtils.createRouteValidationFunction)(_latest.metricsExplorerViewRequestQueryRT)
    }
  }, async (_requestContext, request, response) => {
    const {
      query
    } = request;
    const [,, {
      metricsExplorerViews
    }] = await getStartServices();
    if (metricsExplorerViews === undefined) {
      return response.customError(NON_STARTED_SERVICE_ERROR);
    }
    const metricsExplorerViewsClient = metricsExplorerViews.getScopedClient(request);
    try {
      const metricsExplorerViewsList = await metricsExplorerViewsClient.find(query);
      return response.ok({
        body: _latest.findMetricsExplorerViewResponsePayloadRT.encode({
          data: metricsExplorerViewsList
        })
      });
    } catch (error) {
      var _error$statusCode, _error$message;
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initFindMetricsExplorerViewRoute = initFindMetricsExplorerViewRoute;