"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHasDataFromSystemIntegration = exports.getFilteredHostNames = void 0;
var _server = require("@kbn/observability-plugin/server");
var _lodash = require("lodash");
var _constants = require("../../../../../common/constants");
var _query = require("../helpers/query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilteredHostNames = async ({
  infraMetricsClient,
  from,
  to,
  limit,
  query
}) => {
  var _response$aggregation, _uniqueHostNames$buck, _uniqueHostNames$buck2;
  const response = await infraMetricsClient.search({
    allow_no_indices: true,
    body: {
      size: 0,
      track_total_hits: false,
      query: {
        bool: {
          filter: [...(0, _lodash.castArray)(query), ...(0, _server.rangeQuery)(from, to), (0, _query.getFilterByIntegration)(_constants.SYSTEM_INTEGRATION)]
        }
      },
      aggs: {
        uniqueHostNames: {
          terms: {
            field: _constants.HOST_NAME_FIELD,
            size: limit,
            order: {
              _key: 'asc'
            }
          }
        }
      }
    }
  });
  const {
    uniqueHostNames
  } = (_response$aggregation = response.aggregations) !== null && _response$aggregation !== void 0 ? _response$aggregation : {};
  return (_uniqueHostNames$buck = uniqueHostNames === null || uniqueHostNames === void 0 ? void 0 : (_uniqueHostNames$buck2 = uniqueHostNames.buckets) === null || _uniqueHostNames$buck2 === void 0 ? void 0 : _uniqueHostNames$buck2.map(p => p.key)) !== null && _uniqueHostNames$buck !== void 0 ? _uniqueHostNames$buck : [];
};
exports.getFilteredHostNames = getFilteredHostNames;
const getHasDataFromSystemIntegration = async ({
  infraMetricsClient,
  from,
  to,
  query
}) => {
  const hitCount = await infraMetricsClient.search({
    allow_no_indices: true,
    ignore_unavailable: true,
    body: {
      size: 0,
      terminate_after: 1,
      track_total_hits: true,
      query: {
        bool: {
          filter: [...(0, _lodash.castArray)(query), ...(0, _server.rangeQuery)(from, to), (0, _query.getFilterByIntegration)(_constants.SYSTEM_INTEGRATION)]
        }
      }
    }
  });
  return hitCount.hits.total.value > 0;
};
exports.getHasDataFromSystemIntegration = getHasDataFromSystemIntegration;