"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _plugin_config_types = require("../common/plugin_config_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const config = exports.config = {
  schema: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    }),
    alerting: _configSchema.schema.object({
      inventory_threshold: _configSchema.schema.object({
        group_by_page_size: _configSchema.schema.number({
          defaultValue: 5_000
        })
      }),
      metric_threshold: _configSchema.schema.object({
        group_by_page_size: _configSchema.schema.number({
          defaultValue: 10_000
        })
      })
    }),
    inventory: _configSchema.schema.object({
      compositeSize: _configSchema.schema.number({
        defaultValue: 2000
      })
    }),
    sources: _configSchema.schema.maybe(_configSchema.schema.object({
      default: _configSchema.schema.maybe(_configSchema.schema.object({
        fields: _configSchema.schema.maybe(_configSchema.schema.object({
          message: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
        }))
      }))
    })),
    featureFlags: _configSchema.schema.object({
      customThresholdAlertsEnabled: (0, _configSchema.offeringBasedSchema)({
        traditional: _configSchema.schema.boolean({
          defaultValue: false
        }),
        serverless: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      logsUIEnabled: (0, _configSchema.offeringBasedSchema)({
        traditional: _configSchema.schema.boolean({
          defaultValue: true
        }),
        serverless: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      metricsExplorerEnabled: (0, _configSchema.offeringBasedSchema)({
        traditional: _configSchema.schema.boolean({
          defaultValue: true
        }),
        serverless: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      osqueryEnabled: _configSchema.schema.boolean({
        defaultValue: true
      }),
      inventoryThresholdAlertRuleEnabled: (0, _configSchema.offeringBasedSchema)({
        traditional: _configSchema.schema.boolean({
          defaultValue: true
        }),
        serverless: _configSchema.schema.boolean({
          defaultValue: true
        })
      }),
      metricThresholdAlertRuleEnabled: (0, _configSchema.offeringBasedSchema)({
        traditional: _configSchema.schema.boolean({
          defaultValue: true
        }),
        serverless: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      logThresholdAlertRuleEnabled: (0, _configSchema.offeringBasedSchema)({
        traditional: _configSchema.schema.boolean({
          defaultValue: true
        }),
        serverless: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      alertsAndRulesDropdownEnabled: (0, _configSchema.offeringBasedSchema)({
        traditional: _configSchema.schema.boolean({
          defaultValue: true
        }),
        serverless: _configSchema.schema.boolean({
          defaultValue: true
        })
      }),
      // to be removed in https://github.com/elastic/kibana/issues/221904
      profilingEnabled: _configSchema.schema.boolean({
        defaultValue: false
      }),
      ruleFormV2Enabled: _configSchema.schema.boolean({
        defaultValue: false
      })
    })
  }),
  deprecations: () => [sourceFieldsMessageDeprecation],
  exposeToBrowser: _plugin_config_types.publicConfigKeys
};
const sourceFieldsMessageDeprecation = (settings, fromPath, addDeprecation) => {
  var _settings$xpack, _settings$xpack$infra, _settings$xpack$infra2, _settings$xpack$infra3, _settings$xpack$infra4;
  const sourceFieldsMessageSetting = settings === null || settings === void 0 ? void 0 : (_settings$xpack = settings.xpack) === null || _settings$xpack === void 0 ? void 0 : (_settings$xpack$infra = _settings$xpack.infra) === null || _settings$xpack$infra === void 0 ? void 0 : (_settings$xpack$infra2 = _settings$xpack$infra.sources) === null || _settings$xpack$infra2 === void 0 ? void 0 : (_settings$xpack$infra3 = _settings$xpack$infra2.default) === null || _settings$xpack$infra3 === void 0 ? void 0 : (_settings$xpack$infra4 = _settings$xpack$infra3.fields) === null || _settings$xpack$infra4 === void 0 ? void 0 : _settings$xpack$infra4.message;
  if (sourceFieldsMessageSetting) {
    addDeprecation({
      configPath: `${fromPath}.sources.default.fields.message`,
      title: _i18n.i18n.translate('xpack.infra.deprecations.sourcesDefaultFieldsMessage.title', {
        defaultMessage: 'The "xpack.infra.sources.default.fields.message" setting is deprecated.',
        ignoreTag: true
      }),
      message: _i18n.i18n.translate('xpack.infra.deprecations.sourcesDefaultFieldsMessage.message', {
        defaultMessage: 'Features using this configurations are set to be removed in v9 and this is no longer used.'
      }),
      level: 'warning',
      documentationUrl: `https://www.elastic.co/guide/en/kibana/current/logs-ui-settings-kb.html#general-logs-ui-settings-kb`,
      correctiveActions: {
        manualSteps: [_i18n.i18n.translate('xpack.infra.deprecations.sourcesDefaultFieldsMessage.manualSteps1', {
          defaultMessage: 'Remove "xpack.infra.sources.default.fields.message" from kibana.yml.',
          ignoreTag: true
        })]
      }
    });
  }
};