"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerViewsClient = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _latest = require("../../../common/http_api/latest");
var _metrics_explorer_views = require("../../../common/metrics_explorer_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetricsExplorerViewsClient {
  constructor(http) {
    this.http = http;
  }
  async findMetricsExplorerViews() {
    const response = await this.http.get((0, _latest.getMetricsExplorerViewUrl)()).catch(error => {
      throw new _metrics_explorer_views.FetchMetricsExplorerViewError(`Failed to fetch metrics explorer views: ${error}`);
    });
    const {
      data
    } = (0, _ioTsUtils.decodeOrThrow)(_latest.findMetricsExplorerViewResponsePayloadRT, message => new _metrics_explorer_views.FetchMetricsExplorerViewError(`Failed to decode metrics explorer views: ${message}"`))(response);
    return data;
  }
  async getMetricsExplorerView(metricsExplorerViewId) {
    const response = await this.http.get((0, _latest.getMetricsExplorerViewUrl)(metricsExplorerViewId)).catch(error => {
      throw new _metrics_explorer_views.FetchMetricsExplorerViewError(`Failed to fetch metrics explorer view "${metricsExplorerViewId}": ${error}`);
    });
    const {
      data
    } = (0, _ioTsUtils.decodeOrThrow)(_latest.metricsExplorerViewResponsePayloadRT, message => new _metrics_explorer_views.FetchMetricsExplorerViewError(`Failed to decode metrics explorer view "${metricsExplorerViewId}": ${message}"`))(response);
    return data;
  }
  async createMetricsExplorerView(metricsExplorerViewAttributes) {
    const response = await this.http.post((0, _latest.getMetricsExplorerViewUrl)(), {
      body: JSON.stringify(_latest.createMetricsExplorerViewRequestPayloadRT.encode({
        attributes: metricsExplorerViewAttributes
      }))
    }).catch(error => {
      var _error$body$message, _error$body;
      throw new _metrics_explorer_views.UpsertMetricsExplorerViewError(`Failed to create new metrics explorer view: ${(_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message}`);
    });
    const {
      data
    } = (0, _ioTsUtils.decodeOrThrow)(_latest.metricsExplorerViewResponsePayloadRT, message => new _metrics_explorer_views.UpsertMetricsExplorerViewError(`Failed to decode newly written metrics explorer view: ${message}"`))(response);
    return data;
  }
  async updateMetricsExplorerView(metricsExplorerViewId, metricsExplorerViewAttributes) {
    const response = await this.http.put((0, _latest.getMetricsExplorerViewUrl)(metricsExplorerViewId), {
      body: JSON.stringify(_latest.createMetricsExplorerViewRequestPayloadRT.encode({
        attributes: metricsExplorerViewAttributes
      }))
    }).catch(error => {
      var _error$body$message2, _error$body2;
      throw new _metrics_explorer_views.UpsertMetricsExplorerViewError(`Failed to update metrics explorer view "${metricsExplorerViewId}": ${(_error$body$message2 = (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) !== null && _error$body$message2 !== void 0 ? _error$body$message2 : error.message}`);
    });
    const {
      data
    } = (0, _ioTsUtils.decodeOrThrow)(_latest.metricsExplorerViewResponsePayloadRT, message => new _metrics_explorer_views.UpsertMetricsExplorerViewError(`Failed to decode updated metrics explorer view "${metricsExplorerViewId}": ${message}"`))(response);
    return data;
  }
  deleteMetricsExplorerView(metricsExplorerViewId) {
    return this.http.delete((0, _latest.getMetricsExplorerViewUrl)(metricsExplorerViewId)).then(() => null).catch(error => {
      throw new _metrics_explorer_views.DeleteMetricsExplorerViewError(`Failed to delete metrics explorer view "${metricsExplorerViewId}": ${error}`);
    });
  }
}
exports.MetricsExplorerViewsClient = MetricsExplorerViewsClient;