"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvalidNodeError = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _view_source_configuration_button = require("../../../../components/source_configuration/view_source_configuration_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InvalidNodeError = ({
  nodeName
}) => {
  const tutorialLinkProps = (0, _public.useLinkProps)({
    app: 'integrations',
    hash: '/browse'
  });
  return /*#__PURE__*/_react.default.createElement(CenteredEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.invalidNodeErrorTitle",
      defaultMessage: "Looks like {nodeName} isn't collecting any metrics data",
      values: {
        nodeName
      }
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.invalidNodeErrorDescription",
      defaultMessage: "Double check your configuration"
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      "data-test-subj": "infraInvalidNodeErrorViewSetupInstructionsButton"
    }, tutorialLinkProps, {
      color: "primary",
      fill: true
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.homePage.noMetricsIndicesInstructionsActionLabel",
      defaultMessage: "View setup instructions"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_view_source_configuration_button.ViewSourceConfigurationButton, {
      app: "metrics",
      "data-test-subj": "configureSourceButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.configureSourceActionLabel",
      defaultMessage: "Change source configuration"
    }))))
  });
};
exports.InvalidNodeError = InvalidNodeError;
const CenteredEmptyPrompt = (0, _common.euiStyled)(_eui.EuiEmptyPrompt)`
  align-self: center;
`;