"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SurveySection = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _survey_kubernetes = require("./survey_kubernetes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVENTORY_FEEDBACK_LINK = 'https://ela.st/survey-infra-inventory';
const SurveySection = () => {
  const {
    nodeType
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = (0, _use_kibana.useKibanaEnvironmentContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, nodeType === 'pod' ? /*#__PURE__*/_react.default.createElement(_survey_kubernetes.SurveyKubernetes, null) : /*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
    "data-test-subj": "infraInventoryFeedbackLink",
    formUrl: INVENTORY_FEEDBACK_LINK,
    kibanaVersion: kibanaVersion,
    isCloudEnv: isCloudEnv,
    isServerlessEnv: isServerlessEnv
  }));
};
exports.SurveySection = SurveySection;