"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamPageContentForState = exports.ConnectedStreamPageContent = void 0;
var _react = require("@xstate/react");
var _react2 = _interopRequireWildcard(require("react"));
var _source_loading_page = require("../../../components/source_loading_page");
var _state = require("../../../observability_logs/log_stream_page/state");
var _xstate_helpers = require("../../../observability_logs/xstate_helpers");
var _page_log_view_error = require("../shared/page_log_view_error");
var _stream_page_template = require("./components/stream_page_template");
var _page_logs_content = require("./page_logs_content");
var _page_missing_indices_content = require("./page_missing_indices_content");
var _page_providers = require("./page_providers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectedStreamPageContent = () => {
  const logStreamPageStateService = (0, _state.useLogStreamPageStateContext)();
  const [logStreamPageState, logStreamPageSend] = (0, _react.useActor)(logStreamPageStateService);
  const pageStateCallbacks = (0, _react2.useMemo)(() => {
    return {
      updateTimeRange: timeRange => {
        logStreamPageSend({
          type: 'UPDATE_TIME_RANGE',
          timeRange
        });
      },
      jumpToTargetPosition: targetPosition => {
        logStreamPageSend({
          type: 'JUMP_TO_TARGET_POSITION',
          targetPosition
        });
      },
      jumpToTargetPositionTime: time => {
        logStreamPageSend({
          type: 'JUMP_TO_TARGET_POSITION',
          targetPosition: {
            time
          }
        });
      },
      reportVisiblePositions: visiblePositions => {
        logStreamPageSend({
          type: 'REPORT_VISIBLE_POSITIONS',
          visiblePositions
        });
      },
      startLiveStreaming: () => {
        logStreamPageSend({
          type: 'UPDATE_REFRESH_INTERVAL',
          refreshInterval: {
            pause: false
          }
        });
      },
      stopLiveStreaming: () => {
        logStreamPageSend({
          type: 'UPDATE_REFRESH_INTERVAL',
          refreshInterval: {
            pause: true
          }
        });
      }
    };
  }, [logStreamPageSend]);
  return /*#__PURE__*/_react2.default.createElement(StreamPageContentForState, {
    logStreamPageState: logStreamPageState,
    logStreamPageCallbacks: pageStateCallbacks
  });
};
exports.ConnectedStreamPageContent = ConnectedStreamPageContent;
const StreamPageContentForState = ({
  logStreamPageState,
  logStreamPageCallbacks
}) => {
  if (logStreamPageState.matches('uninitialized') || logStreamPageState.matches({
    hasLogViewIndices: 'uninitialized'
  }) || logStreamPageState.matches('loadingLogView')) {
    return /*#__PURE__*/_react2.default.createElement(_source_loading_page.SourceLoadingPage, null);
  } else if (logStreamPageState.matches('loadingLogViewFailed')) {
    return /*#__PURE__*/_react2.default.createElement(_page_log_view_error.ConnectedLogViewErrorPage, null);
  } else if (logStreamPageState.matches('missingLogViewIndices')) {
    return /*#__PURE__*/_react2.default.createElement(_page_missing_indices_content.StreamPageMissingIndicesContent, null);
  } else if (logStreamPageState.matches({
    hasLogViewIndices: 'initialized'
  })) {
    return /*#__PURE__*/_react2.default.createElement(_stream_page_template.LogStreamPageTemplate, {
      hasData: true,
      isDataLoading: false
    }, /*#__PURE__*/_react2.default.createElement(_page_providers.LogStreamPageContentProviders, {
      logStreamPageState: logStreamPageState,
      logStreamPageCallbacks: logStreamPageCallbacks
    }, /*#__PURE__*/_react2.default.createElement(_page_logs_content.StreamPageLogsContentForState, {
      logStreamPageState: logStreamPageState,
      logStreamPageCallbacks: logStreamPageCallbacks
    })));
  } else {
    return /*#__PURE__*/_react2.default.createElement(_xstate_helpers.InvalidStateCallout, {
      state: logStreamPageState
    });
  }
};
exports.StreamPageContentForState = StreamPageContentForState;