"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReactQueryProvider = ReactQueryProvider;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _merge = _interopRequireDefault(require("lodash/merge"));
var _eui = require("@elastic/eui");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CONFIG = {
  defaultOptions: {
    queries: {
      keepPreviousData: true,
      refetchOnWindowFocus: false
    }
  }
};
function ReactQueryProvider({
  children,
  config = {}
}) {
  const [queryClient] = (0, _react.useState)(() => new _reactQuery.QueryClient((0, _merge.default)(DEFAULT_CONFIG, config)));
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(HideableReactQueryDevTools, null), children);
}
function HideableReactQueryDevTools() {
  const [isHidden, setIsHidden] = (0, _react.useState)(false);
  return !isHidden && process.env.NODE_ENV === 'development' ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraHideableReactQueryDevToolsButton",
    iconType: "cross",
    color: "primary",
    style: {
      zIndex: 99999,
      position: 'fixed',
      bottom: '40px',
      left: '40px'
    },
    onClick: () => setIsHidden(!isHidden),
    "aria-label": _i18n.i18n.translate('xpack.infra.hideableReactQueryDevTools.euiButtonIcon.disableReactQueryDevLabel', {
      defaultMessage: 'Disable React Query Dev Tools'
    })
  }), /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  })) : null;
}