"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricK8sModuleContext = exports.useMetricK8sModule = exports.MetricK8sModuleProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _infra_ml_module = require("../../infra_ml_module");
var _infra_ml_module_configuration = require("../../infra_ml_module_configuration");
var _infra_ml_module_definition = require("../../infra_ml_module_definition");
var _module_descriptor = require("./module_descriptor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMetricK8sModule = ({
  indexPattern,
  sourceId,
  spaceId
}) => {
  const sourceConfiguration = (0, _react.useMemo)(() => ({
    indices: indexPattern.split(','),
    sourceId,
    spaceId
  }), [indexPattern, sourceId, spaceId]);
  const infraMLModule = (0, _infra_ml_module.useInfraMLModule)({
    moduleDescriptor: _module_descriptor.metricHostsModule,
    sourceConfiguration
  });
  const {
    getIsJobConfigurationOutdated
  } = (0, _infra_ml_module_configuration.useInfraMLModuleConfiguration)({
    sourceConfiguration,
    moduleDescriptor: _module_descriptor.metricHostsModule
  });
  const {
    fetchModuleDefinition,
    getIsJobDefinitionOutdated
  } = (0, _infra_ml_module_definition.useInfraMLModuleDefinition)({
    sourceConfiguration,
    moduleDescriptor: _module_descriptor.metricHostsModule
  });
  const hasOutdatedJobConfigurations = (0, _react.useMemo)(() => infraMLModule.jobSummaries.some(getIsJobConfigurationOutdated), [getIsJobConfigurationOutdated, infraMLModule.jobSummaries]);
  const hasOutdatedJobDefinitions = (0, _react.useMemo)(() => infraMLModule.jobSummaries.some(getIsJobDefinitionOutdated), [getIsJobDefinitionOutdated, infraMLModule.jobSummaries]);
  const hasStoppedJobs = (0, _react.useMemo)(() => Object.values(infraMLModule.jobStatus).some(currentJobStatus => currentJobStatus === 'stopped'), [infraMLModule.jobStatus]);
  return {
    ...infraMLModule,
    fetchModuleDefinition,
    hasOutdatedJobConfigurations,
    hasOutdatedJobDefinitions,
    hasStoppedJobs
  };
};
exports.useMetricK8sModule = useMetricK8sModule;
const [MetricK8sModuleProvider, useMetricK8sModuleContext] = (0, _constate.default)(useMetricK8sModule);
exports.useMetricK8sModuleContext = useMetricK8sModuleContext;
exports.MetricK8sModuleProvider = MetricK8sModuleProvider;