"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createProcessStep = exports.ProcessStep = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _create_ml_jobs_button = require("./create_ml_jobs_button");
var _recreate_ml_jobs_button = require("./recreate_ml_jobs_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createProcessStep = props => ({
  title: processStepTitle,
  children: /*#__PURE__*/_react.default.createElement(ProcessStep, props),
  status: props.setupStatus.type === 'pending' ? 'incomplete' : props.setupStatus.type === 'failed' ? 'danger' : props.setupStatus.type === 'succeeded' ? 'complete' : undefined
});
exports.createProcessStep = createProcessStep;
const ProcessStep = ({
  cleanUpAndSetUp,
  errorMessages,
  isConfigurationValid,
  setUp,
  setupStatus,
  viewResults
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, setupStatus.type === 'pending' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.steps.setupProcess.loadingText",
    defaultMessage: "Creating ML job..."
  }))) : setupStatus.type === 'failed' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.steps.setupProcess.failureText",
    defaultMessage: "Something went wrong creating the necessary ML jobs. Please ensure all selected log indices exist."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), setupStatus.reasons.map((errorMessage, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    key: i,
    color: "danger",
    iconType: "warning",
    title: errorCalloutTitle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    transparentBackground: true
  }, errorMessage))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraProcessStepTryAgainButton",
    fill: true,
    onClick: cleanUpAndSetUp
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.steps.setupProcess.tryAgainButton",
    defaultMessage: "Try again"
  }))) : setupStatus.type === 'succeeded' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.steps.setupProcess.successText",
    defaultMessage: "The ML jobs have been set up successfully"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraProcessStepViewResultsButton",
    fill: true,
    onClick: viewResults
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.steps.setupProcess.viewResultsButton",
    defaultMessage: "View results"
  }))) : setupStatus.type === 'required' ? /*#__PURE__*/_react.default.createElement(_create_ml_jobs_button.CreateMLJobsButton, {
    isDisabled: !isConfigurationValid,
    onClick: setUp
  }) : /*#__PURE__*/_react.default.createElement(_recreate_ml_jobs_button.RecreateMLJobsButton, {
    isDisabled: !isConfigurationValid,
    onClick: cleanUpAndSetUp
  }));
};
exports.ProcessStep = ProcessStep;
const errorCalloutTitle = _i18n.i18n.translate('xpack.infra.analysisSetup.steps.setupProcess.errorCalloutTitle', {
  defaultMessage: 'An error occurred'
});
const processStepTitle = _i18n.i18n.translate('xpack.infra.analysisSetup.actionStepTitle', {
  defaultMessage: 'Create ML job'
});