"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobStoppedCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobStoppedCallout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "primary",
  title: jobStoppedTitle
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.analysis.jobStoppedCalloutMessage",
  defaultMessage: "The ML job has been stopped manually or due to a lack of resources. New log entries will not be processed until the job has been restarted.",
  tagName: "p"
}));
exports.JobStoppedCallout = JobStoppedCallout;
const jobStoppedTitle = _i18n.i18n.translate('xpack.infra.logs.analysis.jobStoppedCalloutTitle', {
  defaultMessage: 'ML job stopped'
});