"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPlaceholder = exports.ChartLoadingProgress = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartLoadingProgress = ({
  hasTopMargin = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    css: (0, _react2.css)`
        top: ${hasTopMargin ? euiTheme.size.l : 0};
        z-index: ${Number(euiTheme.levels.header) - 1};
      `
  });
};
exports.ChartLoadingProgress = ChartLoadingProgress;
const ChartPlaceholder = ({
  style
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ChartLoadingProgress, {
    hasTopMargin: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: style,
    justifyContent: "center",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l"
  }))));
};
exports.ChartPlaceholder = ChartPlaceholder;