"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoSizer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AutoSizer extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "element", null);
    (0, _defineProperty2.default)(this, "resizeObserver", null);
    (0, _defineProperty2.default)(this, "windowWidth", -1);
    (0, _defineProperty2.default)(this, "windowHeight", -1);
    (0, _defineProperty2.default)(this, "state", {
      boundsMeasurement: {
        height: void 0,
        width: void 0
      },
      contentMeasurement: {
        height: void 0,
        width: void 0
      }
    });
    (0, _defineProperty2.default)(this, "measure", entry => {
      if (!this.element) {
        return;
      }
      const {
        content = true,
        bounds = false
      } = this.props;
      const {
        boundsMeasurement: previousBoundsMeasurement,
        contentMeasurement: previousContentMeasurement
      } = this.state;
      const boundsRect = bounds ? this.element.getBoundingClientRect() : null;
      const boundsMeasurement = boundsRect ? {
        height: boundsRect.height,
        width: boundsRect.width
      } : previousBoundsMeasurement;
      if (this.props.detectAnyWindowResize && boundsMeasurement) {
        if (boundsMeasurement.width && this.windowWidth !== -1 && this.windowWidth > window.innerWidth) {
          const gap = this.windowWidth - window.innerWidth;
          boundsMeasurement.width = boundsMeasurement.width - gap;
        }
        if (boundsMeasurement.height && this.windowHeight !== -1 && this.windowHeight > window.innerHeight) {
          const gap = this.windowHeight - window.innerHeight;
          boundsMeasurement.height = boundsMeasurement.height - gap;
        }
      }
      this.windowWidth = window.innerWidth;
      this.windowHeight = window.innerHeight;
      const contentRect = content && entry ? entry.contentRect : null;
      const contentMeasurement = contentRect && entry ? {
        height: entry.contentRect.height,
        width: entry.contentRect.width
      } : previousContentMeasurement;
      if ((0, _lodash.isEqual)(boundsMeasurement, previousBoundsMeasurement) && (0, _lodash.isEqual)(contentMeasurement, previousContentMeasurement)) {
        return;
      }
      requestAnimationFrame(() => {
        if (!this.resizeObserver) {
          return;
        }
        this.setState({
          boundsMeasurement,
          contentMeasurement
        });
        if (this.props.onResize) {
          this.props.onResize({
            bounds: boundsMeasurement,
            content: contentMeasurement
          });
        }
      });
    });
    (0, _defineProperty2.default)(this, "updateMeasurement", () => requestAnimationFrame(() => {
      const {
        detectAnyWindowResize
      } = this.props;
      if (!detectAnyWindowResize) return;
      switch (detectAnyWindowResize) {
        case 'height':
          if (this.windowHeight !== window.innerHeight) {
            this.measure(null);
          }
          break;
        case 'width':
          if (this.windowWidth !== window.innerWidth) {
            this.measure(null);
          }
          break;
        default:
          this.measure(null);
      }
    }));
    (0, _defineProperty2.default)(this, "storeRef", element => {
      if (this.element && this.resizeObserver) {
        this.resizeObserver.unobserve(this.element);
      }
      if (element && this.resizeObserver) {
        this.resizeObserver.observe(element);
      }
      this.element = element;
    });
    if (this.props.detectAnyWindowResize) {
      window.addEventListener('resize', this.updateMeasurement);
    }
    this.resizeObserver = new ResizeObserver(entries => {
      entries.forEach(entry => {
        if (entry.target === this.element) {
          this.measure(entry);
        }
      });
    });
  }
  componentWillUnmount() {
    if (this.resizeObserver) {
      this.resizeObserver.disconnect();
      this.resizeObserver = null;
    }
    if (this.props.detectAnyWindowResize) {
      window.removeEventListener('resize', this.updateMeasurement);
    }
  }
  render() {
    const {
      children
    } = this.props;
    const {
      boundsMeasurement,
      contentMeasurement
    } = this.state;
    return children({
      bounds: boundsMeasurement,
      content: contentMeasurement,
      measureRef: this.storeRef
    });
  }
}
exports.AutoSizer = AutoSizer;